/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.ConditionSerializer;
import slimeknights.tconstruct.library.json.JsonCondition;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.UpdateSpillingFluidsPacket;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class SpillingFluidManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(SpillingFluidManager.class);
    public static final String FOLDER = "tinkering/spilling";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonCondition.class, (Object)ConditionSerializer.DESERIALIZER).registerTypeAdapter(JsonCondition.class, (Object)ConditionSerializer.SERIALIZER).registerTypeHierarchyAdapter(ISpillingEffect.class, ISpillingEffect.LOADER).registerTypeAdapter(FluidIngredient.class, (Object)FluidIngredient.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    public static final SpillingFluidManager INSTANCE = new SpillingFluidManager();
    private List<SpillingFluid> fluids = Collections.emptyList();
    private final Map<class_3611, SpillingFluid> cache = new ConcurrentHashMap<class_3611, SpillingFluid>();
    private static final SpillingFluid EMPTY = new SpillingFluid(FluidIngredient.EMPTY, Collections.emptyList());

    private SpillingFluidManager() {
        super(GSON, FOLDER);
    }

    @Deprecated
    public void init() {
        this.addDataPackListeners();
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> JsonUtils.syncPackets(player, joined, new UpdateSpillingFluidsPacket(this.fluids)));
    }

    private void addDataPackListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 pResourceManager, class_3695 pProfiler) {
        long time = System.nanoTime();
        this.fluids = splashList.entrySet().stream().map(entry -> this.loadFluid((class_2960)entry.getKey(), (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).toList();
        this.cache.clear();
        log.info("Loaded {} spilling fluids in {} ms", (Object)this.fluids.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    @Nullable
    private SpillingFluid loadFluid(class_2960 key, JsonElement element) {
        try {
            JsonObject json = class_3518.method_15295((JsonElement)element, (String)"fluid");
            if (json.has("condition")) {
                return null;
            }
            FluidIngredient ingredient = FluidIngredient.deserialize(json, "fluid");
            List<ISpillingEffect> effects = JsonHelper.parseList(json, "effects", obj -> (ISpillingEffect)GSON.fromJson((JsonElement)obj, ISpillingEffect.class));
            return new SpillingFluid(ingredient, effects);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load modifier {}", (Object)key, (Object)e);
            return null;
        }
    }

    void updateFromServer(List<SpillingFluid> fluids) {
        this.fluids = fluids;
        this.cache.clear();
    }

    private SpillingFluid findUncached(class_3611 fluid) {
        for (SpillingFluid recipe : this.fluids) {
            if (!recipe.matches(fluid)) continue;
            return recipe;
        }
        return EMPTY;
    }

    public boolean contains(class_3611 fluid) {
        return this.find(fluid).hasEffects();
    }

    public SpillingFluid find(class_3611 fluid) {
        return this.cache.computeIfAbsent(fluid, this::findUncached);
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("spilling_fluid_manager");
    }
}

